<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Common_model extends CI_Model
{
	public function add($table,$data)
	{
		$query = $this->db->insert($table,$data);
		return TRUE;
	}
	public function add_return_id($table,$data)
	{
		$query = $this->db->insert($table,$data);
		$insert_id = $this->db->insert_id();
		return $insert_id;
	}
	public function gettotal($where_id, $id, $table)
	{
		return $this->db->where($where_id, $id)
        ->count_all_results($table);
	}
	public function select($table)
	{
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_id($id, $table)
	{
		$this->db->where($id);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_by_id($where_id, $id, $table)
	{
		$this->db->where($where_id, $id);
		$query = $this->db->get($table);
		return $query->result();
	}

	public function select_like_by_id($where_id, $id, $table)
	{
		$this->db->like($where_id, $id);
		$query = $this->db->get($table);
		return $query->result();
	}

	public function select_where_in($where_id, $id, $table)
	{
		$this->db->where_in($where_id, $id);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_where2_in($where_id, $id,$where_id2, $id2, $table)
	{
		$this->db->where_in($where_id, $id);
		$this->db->where_in($where_id2, $id2);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_where3_in($where_id, $id,$where_id2, $id2, $where_id3, $id3, $table)
	{
		$this->db->where_in($where_id, $id);
		$this->db->where_in($where_id2, $id2);
		$this->db->where_in($where_id3, $id3);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_where_limit_in($where_id, $id,$table,$limit)
	{
		$this->db->where_in($where_id, $id);
		$this->db->LIMIT($limit);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function select_where2_limit_in($where_id, $id,$where_id2, $id2,$table,$limit)
	{
		$this->db->where_in($where_id, $id);
		$this->db->where_in($where_id2, $id2);
		$this->db->LIMIT($limit);
		$query = $this->db->get($table);
		return $query->result();
	}
	public function update_data($id,$table)
	{
		$this->db->where($id);
		$query = $this->db->get($table);
		return $query->row();
	}

	public function update($id,$data,$table)
	{
		if (empty($id)) return FALSE;

		$this->db->update($table, $data, array('id' => $id));

		return TRUE;
	}

	public function update_id($where_id,$id,$data,$table)
	{
		if (empty($id)) return FALSE;

		$this->db->where($where_id, $id);
		$this->db->update($table, $data);

		return TRUE;
	}

	public function delete($id,$table)
	{
		$this->db->where($id);
		$this->db->delete($table);
		return TRUE;
	}
	public function deleteall($whereid,$id,$table)
	{
		$this->db->where($whereid, $id);
		$this->db->delete($table);
		return TRUE;
	}

	function upload_thumbnail($source_path,$thumb_path,$width,$height)
	{
	  $this->load->library('image_lib');
		$config = array(
				   'source_image'      => $source_path,
				   'new_image'         => $thumb_path,
				   'maintain_ratio'    => false,
				   'width'             => $width,
				   'height'            => $height
				   );

		 $this->image_lib->initialize($config);
		 $this->image_lib->resize();
		 if (!$this->image_lib->resize()) {
		  $this->image_lib->display_errors();
		 }
	}

}
