<?php
Class Enquiry extends CI_Controller{

    function __construct()
    {
        parent::__construct();
        $this->load->model('View_data');
		$this->load->model('Common_model');
        $this->load->helper(array('html','language','form','text'));
		$this->load->library('session');
		$this->load->helper('my_helper');
    }

	
    public function contact_us()
    {
		$name = $this->input->post('name');
		$email = $this->input->post('email');
		$mobile = $this->input->post('mobile');
		$department = $this->input->post('department');
		$message = $this->input->post('message');
		
		$data['name'] = $name;
		$data['email'] = $email;
		$data['mobile'] = $mobile;
		$data['department'] = $department;
		$data['message'] = $message;
		$ci = get_instance();
		$ci->load->library('email');
		
		$config['protocol'] = $ci->config->item('protocol');
		$config['smtp_host'] = $ci->config->item('host');
		$config['smtp_port'] = $ci->config->item('port');
		$config['smtp_user'] = $ci->config->item('user');
		$config['smtp_pass'] = $ci->config->item('pass');
		$config['charset'] = "utf-8";
		$config['mailtype'] = "html";
		//$config['newline'] = "\r\n";

		$ci->email->set_newline("\r\n");	 
	    $ci->email->set_header('HTTP/1.1 200 OK');
	    $ci->email->set_header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
	    $ci->email->set_header('Cache-Control: no-store, no-cache, must-revalidate');
	    $ci->email->set_header('Cache-Control: post-check=0, pre-check=0');
	    $ci->email->set_header('Pragma: no-cache');
		
		$ci->email->initialize($config);   
		$ci->email->from($email, $name);
		$list = array($ci->config->item('to'));
		$ci->email->to($list);    
		$subject = 'Online Enquiry';
		$ci->email->subject($subject);
		$body = $ci->load->view('Frontend/emails/contactenquiry.php',$data,TRUE);
		$ci->email->message($body);
		$ci->load->library('encrypt');
			
	  if($ci->email->send()){
			$this->session->set_flashdata('success', TRUE);
			$mailsubject = 'Thanks For Enquiry';
			$feedback = 'Thank You for enquiry, we will revert to you soon. For Any Query Please call us on :'.$this->config->item('mobile');
			$this->mailtocustomer($name, $email,$mailsubject, $feedback);
			redirect('feedback', 'location');
			} else {
			 $this->session->set_flashdata('success', FALSE);
		   redirect('feedback', 'location');
		}
    }
	public function get_quote()
    {
		$name = $this->input->post('name');
		$email = $this->input->post('email');
		$mobile = $this->input->post('mobile');
		$service = $this->input->post('service');
		$from = $this->input->post('from');
		$to = $this->input->post('to');
		$message = $this->input->post('message');
		
		$data['name'] = $name;
		$data['email'] = $email;
		$data['mobile'] = $mobile;
		$data['service'] = $service;
		$data['from'] = date_indian($from);
		$data['to'] = date_indian($to);
		$data['message'] = $message;
		$ci = get_instance();
		$ci->load->library('email');
		
		$config['protocol'] = $ci->config->item('protocol');
		$config['smtp_host'] = $ci->config->item('host');
		$config['smtp_port'] = $ci->config->item('port');
		$config['smtp_user'] = $ci->config->item('user');
		$config['smtp_pass'] = $ci->config->item('pass');
		$config['charset'] = "utf-8";
		$config['mailtype'] = "html";
		//$config['newline'] = "\r\n";

		$ci->email->set_newline("\r\n");	 
	    $ci->email->set_header('HTTP/1.1 200 OK');
	    $ci->email->set_header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
	    $ci->email->set_header('Cache-Control: no-store, no-cache, must-revalidate');
	    $ci->email->set_header('Cache-Control: post-check=0, pre-check=0');
	    $ci->email->set_header('Pragma: no-cache');
		
		$ci->email->initialize($config);   
		$ci->email->from($email, $name);
		$list = array($ci->config->item('to'));
		$ci->email->to($list);    
		$subject = 'Get Quotes';
		$ci->email->subject($subject);
		$body = $ci->load->view('Frontend/emails/getquote.php',$data,TRUE);
		$ci->email->message($body);
		$ci->load->library('encrypt');
			
	  if($ci->email->send()){
			$this->session->set_flashdata('success', TRUE);
			$mailsubject = 'Thanks For Enquiry';
			$feedback = 'Thank You for enquiry, we will revert to you soon. For Any Query Please call us on :'.$this->config->item('mobile');
			$this->mailtocustomer($name, $email,$mailsubject, $feedback);
			redirect('feedback', 'location');
			} else {
			 $this->session->set_flashdata('success', FALSE);
		   redirect('feedback', 'location');
		}
    }


	public function mailtoadmin($fname,$lname,$email,$mobile,$qualification,$birthdate,$experience,$key_role)
	{
	 $filepath = 'assets/resume'.$mobile.'.pdf';
	 $data['name'] = $fname." ".$lname;
	 $data['email'] = $email;
	 $data['mobile'] = $mobile;
	 $data['qualification'] = $qualification;
	 $data['birthdate'] = $birthdate;
	 $data['experience'] = $experience;
	 $data['keyrole'] = $key_role;
	 
	 $ci = get_instance();
	 $ci->load->library('email');
	 $config['protocol'] = $ci->config->item('protocol');
	 $config['smtp_host'] = $ci->config->item('host');
	 $config['smtp_port'] = $ci->config->item('port');
	 $config['smtp_user'] = $ci->config->item('user');
	 $config['smtp_pass'] = $ci->config->item('pass');
	 $config['charset'] = "utf-8";
	 $config['mailtype'] = "html";
	 //$config['newline'] = "\r\n";

	 $ci->email->set_newline("\r\n");	 
	    $ci->email->set_header('HTTP/1.1 200 OK');
	    $ci->email->set_header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
	    $ci->email->set_header('Cache-Control: no-store, no-cache, must-revalidate');
	    $ci->email->set_header('Cache-Control: post-check=0, pre-check=0');
	    $ci->email->set_header('Pragma: no-cache');
		
		$ci->email->initialize($config);   
		$ci->email->from($email, $name);
		$list = array($ci->config->item('to'));
		$ci->email->to($list);    
		$subject = "Applicant's Details";
		$ci->email->subject($subject);
		$body = $ci->load->view('Frontend/emails/resume-enquiry.php',$data,TRUE);
		$ci->email->attach(FCPATH.$filepath);
		$ci->email->message($body);
		$ci->load->library('encrypt');
	
		$ci->email->send();
	}

	public function mailtocustomer($name, $email,$mailsubject,$feedback)
	{
	 $ci = get_instance();
	 $ci->load->library('email');
	  	$data['feedback'] = $feedback;
		$data['name'] = $name;

	    $ci->load->library('email');
	    $config['protocol'] = $ci->config->item('protocol');
	    $config['smtp_host'] = $ci->config->item('host');
	    $config['smtp_port'] = $ci->config->item('port');
	    $config['smtp_user'] = $ci->config->item('user');
	    $config['smtp_pass'] = $ci->config->item('pass');
	    $config['charset'] = "utf-8";
	    $config['mailtype'] = "html";
	    //$config['newline'] = "\r\n";
	    $ci->email->set_newline("\r\n");	 
	    $ci->email->set_header('HTTP/1.1 200 OK');
	    $ci->email->set_header('Last-Modified: '.gmdate('D, d M Y H:i:s', time()).' GMT');
	    $ci->email->set_header('Cache-Control: no-store, no-cache, must-revalidate');
	    $ci->email->set_header('Cache-Control: post-check=0, pre-check=0');
	    $ci->email->set_header('Pragma: no-cache');

	    $ci->email->initialize($config);   
	    $ci->email->from($ci->config->item('to'), $ci->config->item('company'));
	    $list = array($email);
	    $ci->email->to($list);    
	    $subject = $mailsubject;
	    $ci->email->subject($subject);
	    $body = $ci->load->view('Frontend/emails/mailtocustomer.php',$data,TRUE);
	    $ci->email->message($body);
	    $ci->load->library('encrypt');
        
		if($ci->email->send())
		{
		  return true;
		}
		else {
  
		  return false;
		}
	}

}
